function [TRACKS,TRACKSwithallimmo,allimmobiles, N_origtracks, Orig_immo, LENGTHS, Ext_global, Extdivlength, EXT] = define_tracks(A,T, tau_space, Detect_immimm)

% This function splits the tracks contained in A in sub-tracks of lenght T
%
% INPUT
% - A    : tracks
% - SURF : files conaining the areas of the spots
% - INT  : file containing the intenisy of the spots
% - T    : lenght of the sub-tracks
%
% OUTPUT
% - N_origtracks : number of original tracks that are analyzed (immobile
%                  or splitted in subtracks)
% - allimmobiles : number of  completely immobile tracks
% - Orig_immo : number of original tracks for immobile tracks
% - Ext_global : extent of gloab original tracks
% - TRACKS : structure array with 5 fields
%            TRACKS(i).coord contains [X;Y] coordinates of tracks
%            TRACKS(i).times contains times of  tracks
%            TRACKS(i).surf contains area of spots
%            TRACKS(i).int contains intensity of spots
%            TRACKS(i).orig contains the number of the original track
% All times are considered starting at 1 and not at 0
               

TRACKS =[];
TRACKSwithallimmo = [];
count=1;
countbis=1;
allimmobiles=0;
LENGTHS = [];
Ext_global = [];
Extdivlength=[];
EXT=[];
ind =find(isnan(A(:,1))==0);
N=numel(ind);
SURF=zeros(600,N+1);
N_origtracks=0;
Orig_immo=[];

%%
for i=1:N-1  

   ind1 = find(A(:,1)==i-1);
   ind2 = find(A(:,1)==i);   
   l = numel(A(ind1+2:ind2-2,3)');   
   %%%%%%%%%%%%%%%%%%%%%
   if l>= T+1
    N_origtracks=N_origtracks+1;  
    LENGTHS=[LENGTHS, l];
    
   % Extent of global tracks
     X = tau_space.*[A(ind1+2:ind2-2,3)';A(ind1+2:ind2-2,4)'];
     countext=1;
     test_immo=[];
      for l=1:size(X,2)
          for k=l:size(X,2)
              test_immo(countext)=norm(X(:,l)-X(:,k),2);
              countext=countext+1;
          end
      end
      extent = max(test_immo);
      Ext_global=[Ext_global,extent];
      Extdivlength = [Extdivlength, extent/l];
      EXT = [EXT,[extent;Detect_immimm(i);l]];
      taille=2;

      
      if  extent <= taille*tau_space*sqrt(2)
          allimmobiles=allimmobiles+1;
          Orig_immo=[Orig_immo,Detect_immimm(i)];
          K = floor((l-mod(l,T))/T);
          a=ind1+2;
          for k=1:K
              b=a+T;
              
              TRACKSwithallimmo(countbis).coord = [A(a:b,3)';A(a:b,4)'];
              TRACKSwithallimmo(countbis).times = A(a:b,2)'+1;
              % TRACKSwithallimmo(countbis).int = INT(A(a:b,2)+1, i+1)';
              % TRACKSwithallimmo(count).surf = SURF(A(a:b,2)+1, i+1)';
              TRACKSwithallimmo(countbis).int = zeros(1,T+1);
              TRACKSwithallimmo(countbis).surf = zeros(1,T+1);
              TRACKSwithallimmo(countbis).orig =Detect_immimm(i);
              countbis=countbis+1;
              a=b;   %a=b+1;
          end
          
      else
          
          K = floor((l-1-mod(l-1,T))/T);
          a=ind1+2;
          for k=1:K
              b=a+T;
              
              TRACKSwithallimmo(countbis).coord = [A(a:b,3)';A(a:b,4)'];
              TRACKSwithallimmo(countbis).times = A(a:b,2)'+1;
              % TRACKSwithallimmo(countbis).int = INT(A(a:b,2)+1, i+1)';
              % TRACKSwithallimmo(count).surf = SURF(A(a:b,2)+1, i+1)';
              TRACKSwithallimmo(countbis).int = zeros(1,T+1);
              TRACKSwithallimmo(countbis).surf = zeros(1,T+1);
              TRACKSwithallimmo(countbis).orig = Detect_immimm(i);
              countbis=countbis+1;
              
              TRACKS(count).coord = [A(a:b,3)';A(a:b,4)'];
              TRACKS(count).times = A(a:b,2)'+1;
              % TRACKS(count).int = INT(A(a:b,2)+1, i+1)';
              % TRACKS(count).surf = SURF(A(a:b,2)+1, i+1)';
              TRACKS(count).int = zeros(1,T+1);
              TRACKS(count).surf = zeros(1,T+1);
              TRACKS(count).orig = Detect_immimm(i);
              count=count+1;
              a=b;   %a=b+1;
              
              
          end
      end
    end
end

end
